function mpc =Network2																										
%% INESC TEC 27/05/2020																										
%% MATPOWER Case Format : Version 2																										
mpc.version = '2';																										
																										
%%-----  Power Flow Data  -----%%																										
%% system MVA base																										
mpc.baseMVA = 100;																										
																										
%% system voltage levels (kV)																										
mpc.V_levels = [																										
	15	30	60																							
];																										
																										
%% bus data																										
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	hasGEN	isLOAD	SNOM_MVA	SX	SY	GX	GY						
mpc.bus = [																										
	1	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	2	1	0.0032	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	3	1	0.404	-0.0957	0	0	1	1	0	15	1	1.1	0.9	0	1	0	0	0	0	0;						
	4	1	0.00291	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	5	1	0	0	0.01	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	6	3	0	0	0.0158	0	1	1	0	60	1	1.1	0.9	1	0	0	0	0	0	0;						
	7	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	8	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	9	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	10	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	11	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	12	1	0.123	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	13	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	14	1	0.228	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	15	1	0.0689	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	16	1	0.0623	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	17	1	0.006	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.05	0	0	0	0;						
	18	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	19	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	20	1	0.136	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	21	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	22	1	0.0261	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	23	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	24	1	0.249	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	25	1	0.005	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.025	0	0	0	0;						
	26	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	27	1	0.16	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	28	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	29	1	0.704	0	0	0	1	1	0	30	1	1.1	0.9	0	1	2.66	0	0	0	0;						
	30	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	31	1	0.22	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	32	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	33	1	0.0029	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.025	0	0	0	0;						
	34	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	35	1	0.257	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	36	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	37	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	38	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	39	1	0.0657	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	40	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	41	1	0.041	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	42	1	0.0793	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	43	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	44	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	45	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	46	1	0.006	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.025	0	0	0	0;						
	47	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	48	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	49	1	0.0868	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	50	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	51	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	52	1	0.626	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.43	0	0	0	0;						
	53	1	0.0098	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	54	1	0.205	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	55	1	0.0217	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	56	1	0.0715	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	57	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	58	1	0.427	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	59	1	0.265	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	60	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	61	1	0.243	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	62	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	63	1	0.529	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.5	0	0	0	0;						
	64	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	65	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	66	1	0.0803	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	67	1	0.0905	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	68	1	0.0764	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	69	1	0.399	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	70	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	71	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	72	1	0.151	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	73	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	74	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	75	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	76	1	0.0679	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	77	1	0.141	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	78	1	0.0411	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	79	1	0.0416	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	80	1	0.767	0	0	0	1	1	0	30	1	1.1	0.9	0	1	2	0	0	0	0;						
	81	1	0.0525	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	82	1	0.157	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	83	1	0.2	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	84	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	85	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	86	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	87	1	0.0236	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.2	0	0	0	0;						
	88	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	89	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	90	1	0.0258	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	91	1	0.0927	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	92	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	93	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	94	1	0.0643	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	95	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	96	1	0.22	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	97	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	98	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	99	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	100	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	101	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	102	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	103	1	0.0895	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	104	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	105	1	0.594	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.6	0	0	0	0;						
	106	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	107	1	0.0595	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	108	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	109	1	0.143	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	110	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	111	1	0.438	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	112	1	0.132	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	113	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	114	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	115	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	116	1	0.0758	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.1419	0	0	0	0;						
	117	1	0.0608	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	118	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.05	0	0	0	0;						
	119	1	0.0987	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	120	1	0.169	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	121	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	122	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	123	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	1	0.05	0	0	0	0;						
	124	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	125	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	126	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	127	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	128	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	129	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	130	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	131	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	132	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	133	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	134	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	135	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	136	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	137	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	138	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	139	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	140	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	141	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	142	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	143	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	144	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	145	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	146	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	147	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	148	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	149	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	150	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	151	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	152	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	153	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	154	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	155	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	156	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	157	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	158	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	159	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	160	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	161	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	162	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	163	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	164	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	165	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	166	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	167	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	168	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	169	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	170	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	171	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	172	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	173	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	174	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	175	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	176	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	177	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	178	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	179	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	180	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	181	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	182	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	183	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	184	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	185	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	186	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	187	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	188	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	189	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	190	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	191	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	192	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	193	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	194	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	195	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	196	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	197	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	198	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	199	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	200	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	201	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	202	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	203	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	204	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	205	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	206	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	207	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	208	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	209	1	0	0	0	3.43	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	210	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	211	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	212	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	213	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	214	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	215	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	216	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	217	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	218	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	219	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	220	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	221	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	222	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	223	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	224	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	225	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	226	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	227	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	228	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
	229	1	0	0	0	0	1	1	0	15	1	1.1	0.9	0	0	0	0	0	0	0;						
];																										
																										
%% CAPACITOR BANK Data																										
%	bus_i	Node_ID	bank_ID	Qnom (Mvar)																						
mpc.capacitor_bank_dplan = {																										
	209	'209'	'1'	3.43053;																						
};																										
																										
%% generator data																										
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	ID				
mpc.gen = [																										
	6	0	0	9999	-9999	1	100	1	9999	-9999	0	0	0	0	0	0	0	0	0	0	0	1;		
	4	0	0	9999	-9999	1	100	1	5	0	0	0	0	0	0	0	0	0	0	0	0	1;		
];																										
																										
%% branch data																										
%	fbus	tbus	r	x	b	rateA (typical)	rateB (summer)	rateC (winter)	ratio	angle	status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	nominalRatio	r_ip	r_n	r0	x0	b0	length (meter)	NormSTAT
mpc.branch = [																										
	210	207	0.0478	0.028	0.0000179	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0587	0.116	0.00000894	661.52	1;
	210	12	0.0175	0.0103	0.00000656	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0215	0.0427	0.00000328	242.66	1;
	170	131	0.00724	0.00249	0.00000131	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00811	0.00962	0.000000652	53.43	1;
	162	161	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.06	1;
	163	162	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	195	140	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.09	1;
	192	175	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.07	1;
	176	129	0.0207	0.0112	0.00000665	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0249	0.0443	0.00000332	254.89	1;
	219	142	0.00554	0.00506	0.00000332	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00753	0.0208	0.00000166	121.17	1;
	170	134	0.028	0.00965	0.00000506	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0314	0.0373	0.00000253	207.05	1;
	207	50	0.00466	0.00251	0.0000015	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0056	0.00998	0.000000748	57.37	1;
	210	15	0.0262	0.0153	0.00000979	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0322	0.0637	0.00000489	362.32	1;
	200	147	0.00569	0.0102	0.00000678	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00973	0.0422	0.00000339	245.87	1;
	67	157	0.00315	0.00184	0.00000118	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00387	0.00766	0.000000589	43.6	1;
	218	42	0.00123	0.000662	0.000000394	9.25	6.91	9.25	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00148	0.00263	0.000000197	15.1	1;
	219	200	0.00266	0.00478	0.00000318	18.7	13.7	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00456	0.0198	0.00000159	115	1;
	217	142	0.00335	0.00306	0.00000201	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00455	0.0126	0.000001	73.33	1;
	105	198	0.00118	0.000635	0.000000378	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00142	0.00252	0.000000189	14.5	1;
	207	188	0.00931	0.00502	0.00000299	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0112	0.0199	0.00000149	114.58	1;
	145	139	0.0137	0.00738	0.0000044	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0165	0.0293	0.0000022	168.6	1;
	187	143	0.011	0.0101	0.00000662	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.015	0.0416	0.00000331	241.77	1;
	138	136	0.0116	0.00677	0.00000433	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0142	0.0281	0.00000216	160.08	1;
	202	135	0.0124	0.0193	0.0000141	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0204	0.0827	0.00000705	487.04	1;
	219	90	0.00108	0.000582	0.000000347	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0013	0.00231	0.000000174	13.31	1;
	83	179	0.00363	0.00196	0.00000117	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00436	0.00777	0.000000583	44.67	1;
	213	125	0.00312	0.00486	0.00000355	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00514	0.0208	0.00000177	122.56	1;
	68	176	0.00996	0.00583	0.00000372	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0122	0.0242	0.00000186	137.8	1;
	186	156	0.0119	0.0064	0.00000381	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0143	0.0254	0.00000191	146.18	1;
	174	172	0.013	0.00447	0.00000234	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0146	0.0173	0.00000117	95.94	1;
	149	33	0.00742	0.004	0.00000238	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00892	0.0159	0.00000119	91.36	1;
	109	160	0.00412	0.00222	0.00000132	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00495	0.00882	0.000000661	50.71	1;
	194	125	0.0145	0.0225	0.0000164	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0238	0.0962	0.00000821	567.07	1;
	187	167	0.0199	0.00673	0.00000391	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0224	0.027	0.00000195	151.9	1;
	49	159	0.00144	0.000776	0.000000462	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00173	0.00308	0.000000231	17.73	1;
	208	157	0.00324	0.00488	0.00000344	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00518	0.0205	0.00000154	120.78	1;
	173	156	0.0318	0.0186	0.0000119	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.039	0.0774	0.00000594	440.02	1;
	166	164	0.0422	0.0247	0.0000158	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0518	0.103	0.00000789	583.97	1;
	183	35	0.0029	0.00156	0.00000093	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00348	0.0062	0.000000465	35.65	1;
	190	133	0.00643	0.00354	0.000002	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00773	0.0141	0.000001	78.9	1;
	169	166	0.00366	0.00214	0.00000137	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0045	0.00891	0.000000685	50.68	1;
	208	124	0.00284	0.00427	0.00000301	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00454	0.0179	0.00000135	105.68	1;
	168	132	0.00282	0.00152	0.000000907	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00339	0.00604	0.000000453	34.76	1;
	198	82	0.000816	0.000477	0.000000305	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.001	0.00198	0.000000152	11.28	1;
	190	126	0.00484	0.00752	0.00000549	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00795	0.0322	0.00000274	189.7	1;
	76	137	0.00215	0.00116	0.00000069	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00259	0.0046	0.000000345	26.47	1;
	201	180	0.00371	0.00558	0.00000394	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00593	0.0234	0.00000176	138.12	1;
	53	124	0.00116	0.000681	0.000000435	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00143	0.00283	0.000000218	16.11	1;
	201	124	0.00197	0.00297	0.0000021	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00316	0.0125	0.000000939	73.56	1;
	173	169	0.0101	0.00591	0.00000377	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0124	0.0246	0.00000189	139.66	1;
	193	134	0.0513	0.0177	0.00000926	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0576	0.0683	0.00000463	379.03	1;
	220	160	0.00689	0.0107	0.00000782	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0113	0.0458	0.00000391	270.11	1;
	180	177	0.00246	0.00371	0.00000262	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00394	0.0156	0.00000117	91.83	1;
	150	138	0.00456	0.00688	0.00000485	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0073	0.0288	0.00000217	170.11	1;
	204	177	0.00322	0.00486	0.00000342	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00515	0.0203	0.00000153	120.09	1;
	103	198	0.0224	0.0131	0.00000835	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0274	0.0543	0.00000418	309.16	1;
	61	129	0.00495	0.00267	0.00000159	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00595	0.0106	0.000000795	60.96	1;
	184	22	0.00591	0.00319	0.0000019	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00711	0.0127	0.00000095	72.82	1;
	214	211	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	183	181	0.014	0.0128	0.0000084	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0191	0.0527	0.0000042	306.86	1;
	218	137	0.00367	0.00198	0.00000118	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00441	0.00785	0.000000589	45.17	1;
	205	127	0.0154	0.014	0.00000921	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0209	0.0578	0.0000046	336.31	1;
	181	127	0.00196	0.00179	0.00000117	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00266	0.00737	0.000000587	42.9	1;
	151	25	0.0318	0.0171	0.0000102	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0382	0.068	0.0000051	391.13	1;
	156	129	0.0157	0.00846	0.00000504	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0189	0.0336	0.00000252	193.26	1;
	81	130	0.0052	0.00179	0.000000937	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00583	0.00691	0.000000468	38.36	1;
	212	184	0.00558	0.0051	0.00000334	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00759	0.021	0.00000167	122.11	1;
	176	148	0.0111	0.00596	0.00000355	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0133	0.0237	0.00000178	136.25	1;
	204	203	0.00182	0.00274	0.00000193	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00291	0.0115	0.000000866	67.84	1;
	142	19	0.00115	0.000622	0.000000371	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00139	0.00247	0.000000185	14.21	1;
	215	199	0.00289	0.00156	0.000000927	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00347	0.00618	0.000000463	35.54	1;
	218	78	0.0079	0.00426	0.00000254	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00949	0.0169	0.00000127	97.23	1;
	197	55	0.00107	0.000575	0.000000343	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00128	0.00229	0.000000171	13.14	1;
	107	215	0.00311	0.00182	0.00000116	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00382	0.00757	0.000000582	43.05	1;
	190	135	0.00158	0.00245	0.00000179	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0026	0.0105	0.000000896	61.91	1;
	77	165	0.00323	0.00189	0.00000121	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00396	0.00785	0.000000603	44.65	1;
	87	133	0.00281	0.00152	0.000000903	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00338	0.00602	0.000000452	34.63	1;
	178	126	0.00977	0.0152	0.0000111	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0161	0.065	0.00000554	383.19	1;
	216	213	0.00214	0.00332	0.00000243	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00351	0.0142	0.00000121	83.83	1;
	94	154	0.0102	0.00346	0.00000201	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0115	0.0139	0.000001	78.02	1;
	165	128	0.0467	0.0273	0.0000175	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0573	0.114	0.00000873	645.9	1;
	216	160	0.00255	0.00397	0.0000029	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0042	0.017	0.00000145	100.12	1;
	179	152	0.00818	0.00441	0.00000263	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00983	0.0175	0.00000131	100.71	1;
	220	174	0.00904	0.0141	0.0000103	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0149	0.0602	0.00000513	354.81	1;
	73	143	0.00539	0.00182	0.00000106	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00607	0.0073	0.000000529	41.08	1;
	202	194	0.00828	0.0129	0.00000941	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0136	0.0552	0.0000047	324.99	1;
	197	133	0.00518	0.00285	0.00000161	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00622	0.0113	0.000000807	63.52	1;
	193	137	0.0093	0.00501	0.00000299	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0112	0.0199	0.00000149	114.56	1;
	184	159	0.0242	0.0222	0.0000145	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0329	0.0911	0.00000726	530.32	1;
	117	225	0.055	0.0322	0.00000128	4.96	3.6893	4.9623	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0675	0.134	0.000000643	190.17	1;
	228	224	0	0.0001	0	260	259.7816	259.7816	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	116	225	0.303	0.177	0.00000707	4.96	3.6893	4.9623	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.372	0.736	0.00000354	1047.14	1;
	6	1	0.0171	0.356	0	20	20	20	1	0	1	-360	360	1.4133	13	1	25	13	0.9606	0	0	0.186	0.169	0	0	1;
	5	3	0.102	0.924	0	10	10	10	1	0	1	-360	360	3.3333	4	1	7	4	1	0	0	0.513	0.467	0	0	1;
	146	167	0.0467	0.0158	0.00000917	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0526	0.0633	0.00000458	356.15	1;
	149	188	0.0275	0.0148	0.00000882	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.033	0.0588	0.00000441	338.13	1;
	161	163	0	0.0002	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.1	1;
	145	154	0.0649	0.0219	0.0000127	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0731	0.088	0.00000637	494.85	1;
	141	154	0.0195	0.00659	0.00000383	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.022	0.0264	0.00000191	148.75	1;
	69	155	0.0104	0.00561	0.00000334	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0125	0.0223	0.00000167	128.08	1;
	198	141	0.022	0.0118	0.00000705	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0264	0.047	0.00000353	270.48	1;
	229	226	0.102	0.154	0.00000677	9.15	6.6251	9.1452	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.163	0.643	0.00000303	949.34	1;
	140	192	0	0.0002	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.16	1;
	206	72	0	0.0002	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.29	1;
	54	196	0	0.0002	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.33	1;
	20	127	0.0115	0.00877	0.0000056	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0149	0.0357	0.0000028	207.21	1;
	138	199	0.00961	0.00538	0.00000331	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0117	0.0218	0.00000166	124.9	1;
	164	153	0.0325	0.0184	0.0000114	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0396	0.0749	0.00000569	427.81	1;
	205	46	0.0315	0.0272	0.0000177	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0421	0.112	0.00000886	649.87	1;
	148	144	0.00926	0.0052	0.00000321	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0112	0.0211	0.00000161	120.86	1;
	191	164	0.0374	0.0215	0.0000136	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0457	0.0887	0.00000679	505.57	1;
	161	21	0	0.0003	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.02	1;
	1	140	0	0.0012	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.13	1;
	189	65	0	0.0006	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	153	202	0.0255	0.0138	0.00000817	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0306	0.0545	0.00000409	313.38	1;
	139	217	0.0394	0.0214	0.0000127	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0474	0.0844	0.00000633	485.66	1;
	96	151	0.000402	0.0004	0.00000193	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000818	0.000794	0.00000188	7.08	1;
	101	165	0.00439	0.00347	0.00000164	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00539	0.0107	0.000000821	61.21	1;
	126	130	0.0265	0.0147	0.00000825	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0318	0.0579	0.00000413	324.85	1;
	158	149	0.0306	0.0166	0.00000983	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0368	0.0655	0.00000491	376.8	1;
	220	30	0.00753	0.00456	0.00000242	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00906	0.0161	0.00000121	94.14	1;
	135	28	0.00168	0.0018	0.000000538	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00202	0.00359	0.000000269	23.12	1;
	168	202	0.0974	0.0536	0.0000304	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.117	0.213	0.0000152	1195.18	1;
	37	168	0.00465	0.00306	0.00000145	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00559	0.0102	0.000000725	58.43	1;
	26	156	0.00125	0.00143	0.000000466	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00153	0.00303	0.000000233	17.73	1;
	23	182	0.0479	0.0269	0.0000149	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0575	0.105	0.00000747	591.05	1;
	191	17	0.0386	0.0208	0.0000124	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0465	0.0827	0.00000621	475.85	1;
	59	199	0.00174	0.00087	0.000022	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0061	0.00295	0.000022	46.98	1;
	189	197	0.0447	0.0245	0.0000605	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0623	0.0958	0.0000541	604.75	1;
	14	179	0.00282	0.00142	0.0000215	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00724	0.00528	0.0000213	59.18	1;
	34	171	0.0178	0.0101	0.00000572	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0214	0.0381	0.00000286	222.99	1;
	186	44	0.0172	0.0098	0.00000554	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0207	0.0369	0.00000277	213.68	1;
	56	169	0.000789	0.000609	0.000000295	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000968	0.00192	0.000000147	10.91	1;
	51	194	0.0319	0.0184	0.00000999	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0383	0.0695	0.000005	393.26	1;
	166	48	0.000142	0.0008	4.55E-08	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00017	0.000303	2.27E-08	2.98	1;
	5	192	0	0.0014	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.21	1;
	32	131	0.00101	0.00126	0.000000315	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00121	0.00221	0.000000158	14.54	1;
	79	173	0.0111	0.00645	0.00000658	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.014	0.0262	0.00000459	152.66	1;
	8	175	0	0.0006	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	9	175	0	0.0007	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.1	1;
	85	141	0.0129	0.00504	0.00000252	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0145	0.0174	0.00000126	99.41	1;
	91	137	0.000933	0.00045	0.00000435	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00199	0.00121	0.00000431	13.84	1;
	139	36	0.0179	0.0102	0.00000576	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0216	0.0384	0.00000288	220.8	1;
	147	163	0.000342	0.0009	0.00000354	14.5	13.6659	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00108	0.00105	0.00000349	14.33	1;
	41	208	0.0135	0.00741	0.00000576	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0165	0.0288	0.00000362	167.46	1;
	38	134	0.0316	0.0114	0.0000057	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0354	0.042	0.00000285	236.8	1;
	136	182	0.0384	0.0177	0.00000974	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0448	0.0695	0.00000487	388.24	1;
	31	189	0	0.0004	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	4.6	1;
	172	58	0.00375	0.00147	0.00000615	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00525	0.00513	0.00000585	36.17	1;
	64	181	0.00694	0.00444	0.00000223	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00834	0.0149	0.00000111	86.14	1;
	24	186	0.0237	0.0111	0.000141	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0534	0.0457	0.000139	449.7	1;
	27	214	0	0.0004	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	4.91	1;
	152	174	0.00968	0.0151	0.000011	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0159	0.0645	0.0000055	379.85	1;
	188	29	0.0216	0.00801	0.000285	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0778	0.0358	0.000285	594.51	1;
	125	47	0.00176	0.00153	0.000000659	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00216	0.00429	0.00000033	25.19	1;
	158	183	0.078	0.0421	0.0000251	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0938	0.167	0.0000125	960.53	1;
	132	75	0.0358	0.0198	0.0000115	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0431	0.0767	0.00000575	442.28	1;
	203	71	0.013	0.00753	0.00000419	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0157	0.0279	0.0000021	160.77	1;
	7	195	0	0.0007	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.1	1;
	201	57	0.000902	0.00103	0.000000337	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00111	0.00219	0.000000169	16.15	1;
	206	150	0.0138	0.0045	0.000077	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0322	0.016	0.0000767	217.63	1;
	211	18	0	0.0004	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	63	216	0.00495	0.00284	0.00000469	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00654	0.0105	0.00000394	64.68	1;
	217	178	0.0119	0.0159	0.0000111	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0183	0.0662	0.00000555	388.56	1;
	187	147	0.0207	0.0191	0.0000124	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0282	0.078	0.00000622	454.08	1;
	212	183	0.00502	0.00469	0.00000301	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00683	0.0189	0.0000015	109.92	1;
	150	157	0.00391	0.00615	0.00000415	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00625	0.0247	0.00000186	145.69	1;
	88	146	0.029	0.0105	0.00000568	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0326	0.0392	0.00000284	220.84	1;
	80	196	0.00206	0.00116	0.0000132	10.4	9.7168	10.9639	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00517	0.00197	0.0000132	36.36	1;
	191	104	0.00065	0.000996	0.000000209	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000781	0.00139	0.000000104	9.21	1;
	144	66	0.00797	0.00477	0.00000298	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00979	0.0194	0.00000149	110.28	1;
	89	142	0.00638	0.00394	0.00000205	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00767	0.0137	0.00000102	79.8	1;
	167	74	0.00113	0.00167	0.00000988	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00311	0.00175	0.00000985	26.57	1;
	146	92	0.041	0.0143	0.00000804	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0461	0.0555	0.00000402	312.41	1;
	40	153	0.000518	0.00095	0.000000194	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000636	0.00126	9.68E-08	7.84	1;
	108	152	0.00229	0.00214	0.000000736	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00276	0.00491	0.000000368	30.68	1;
	95	212	0.0107	0.00677	0.000004	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0131	0.026	0.000002	150.23	1;
	205	62	0.000508	0.000774	0.000000163	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000611	0.00109	8.16E-08	6.35	1;
	96	4	0.000219	0.001	0.00000293	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000797	0.000363	0.00000293	55.44	1;
	215	93	0.0013	0.0012	0.000000419	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00157	0.00279	0.000000209	16.15	1;
	111	177	0.00341	0.00139	0.0000133	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00674	0.00536	0.000013	51.15	1;
	39	144	0.0078	0.00471	0.00000291	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00957	0.019	0.00000146	107.83	1;
	185	100	0	0.0004	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	16	172	0.00101	0.000579	0.0000104	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0031	0.0018	0.0000103	24.4	1;
	185	143	0.0514	0.0285	0.0000187	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0621	0.11	0.0000104	636.48	1;
	185	128	0.0863	0.0458	0.000141	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.125	0.181	0.000128	1199.16	1;
	184	52	0.00694	0.0037	0.000018	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0113	0.0143	0.0000171	104.19	1;
	29	2	0.000284	0.001	0.0000038	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00103	0.000471	0.0000038	21.51	1;
	209	195	0	0.0015	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.17	1;
	97	200	0.0073	0.00381	0.0000967	14.5	13.6659	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0264	0.0125	0.0000966	205.1	1;
	158	151	0.0411	0.0222	0.0000132	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0494	0.088	0.0000066	506.08	1;
	216	13	0.0224	0.0128	0.00000699	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0269	0.0491	0.0000035	276.73	1;
	98	204	0.00339	0.00269	0.00000127	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00417	0.00825	0.000000634	47.29	1;
	178	70	0.0131	0.00759	0.00000422	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0158	0.0281	0.00000211	161.97	1;
	211	162	0.00232	0.00184	0.0000309	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00841	0.00383	0.0000309	66.7	1;
	196	150	0.00192	0.00197	0.0000639	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0116	0.00627	0.0000639	108.27	1;
	99	155	0.000464	0.0011	0.0000027	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00103	0.000898	0.00000266	10.86	1;
	102	214	0.00785	0.00424	0.000105	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0285	0.013	0.000105	221.41	1;
	182	131	0.0118	0.00665	0.00000368	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0142	0.0258	0.00000184	144.69	1;
	170	171	0.0523	0.0251	0.0000798	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0763	0.0993	0.0000731	677.88	1;
	180	60	0.0121	0.00357	0.0000647	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0276	0.0146	0.0000643	186.63	1;
	84	128	0.0176	0.00999	0.00000566	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0211	0.0377	0.00000283	217.06	1;
	43	206	0.00285	0.00243	0.000038	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0103	0.00471	0.000038	83.8	1;
	155	193	0.0264	0.0196	0.000013	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0342	0.082	0.0000064	472.11	1;
	113	130	0.0465	0.0263	0.0000145	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0559	0.102	0.00000726	572.33	1;
	11	145	0.0045	0.00343	0.00000145	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00541	0.00964	0.000000723	56.7	1;
	112	213	0.00364	0.00231	0.00000393	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00494	0.0087	0.00000329	53.11	1;
	86	136	0.00316	0.00244	0.000000985	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0038	0.00692	0.000000493	40.11	1;
	171	106	0.0427	0.0235	0.0000137	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0514	0.0914	0.00000686	529.58	1;
	148	45	0.00346	0.00236	0.00000111	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00415	0.0074	0.000000555	42.65	1;
	110	132	0.0686	0.0375	0.000022	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0825	0.147	0.000011	844.48	1;
	10	203	0.0102	0.00705	0.000112	14.5	13.2502	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.033	0.0265	0.00011	303.85	1;
	228	122	0	0.0004	0	260	259.7816	259.7816	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.06	1;
	221	120	0.288	0.169	0.00000673	4.96	3.6893	4.9623	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.354	0.701	0.00000337	997.15	1;
	222	115	0	0.0004	0	260	259.7816	259.7816	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.06	1;
	225	226	0.373	0.218	0.0000087	4.96	3.6893	4.9623	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.457	0.906	0.00000435	1288.27	1;
	229	3	0.806	1.15	0.000287	4.62	3.4554	4.6246	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.62	4.87	0.00026	7867.12	1;
	227	222	0.0388	0.0132	0.0000498	7.25	6.9109	8.4437	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.142	0.0617	0.0000498	274.33	1;
	119	227	0	0.0009	0	260	259.7816	259.7816	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.6	1;
	222	224	0.0802	0.0279	0.00011	6.57	6.1315	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.309	0.136	0.00011	597.29	1;
	229	123	0.00602	0.00403	0.000000141	4.96	3.6893	4.9623	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00739	0.0146	7.04E-08	20.93	1;
	114	223	0	0.0003	0	260	259.7816	259.7816	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.12	1;
	223	227	0.0905	0.0295	0.000116	7.25	6.9109	8.4437	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.332	0.144	0.000116	633.6	1;
	221	226	0.215	0.324	0.0000143	9.15	6.6251	9.1452	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.344	1.36	0.00000639	2002.3	1;
	224	221	0.0422	0.03	0.0000378	7.25	6.6251	8.4437	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.127	0.131	0.0000373	327.15	1;
	118	223	0.0904	0.0289	0.000116	7.25	6.9109	8.4437	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.332	0.144	0.000116	628.66	1;
	228	121	0.232	0.0318	0.000102	3.14	2.9358	3.2996	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.468	0.143	0.000102	607.39	1;
	8	152	0.0424	0.0505	0.000657	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.153	0.222	0.000643	1995.96	1;
	159	9	0.104	0.147	0.000732	18.7	13.562	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.255	0.632	0.000683	4418.76	1;
	7	155	0.0542	0.0776	0.00034	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.127	0.333	0.000314	2292.76	1;
];																										
																										
%%-----  OPF Data  -----%%																										
%% generator cost data																										
%	1	startup	shutdown	n	x1	y1	...	xn	yn																	
%	2	startup	shutdown	n	c(n-1)	...	c0																			
mpc.gencost = [																										
	2	0	0	3	0	0	  0.00;
	2	0	0	3	0	0	  0.00;		
];																										
																										
																										
% 																										
% mpc.trans																										
% from bus	to bus	min	max	totaltaps	tap																					
mpc.trans=[6	1	0.8304	1.1696	25	13];																					
